<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
ensure_csrf();

$props = $pdo->query("SELECT id,name FROM properties ORDER BY name")->fetchAll();
$search = trim($_GET['q'] ?? '');
$prop_id = (int)($_GET['property_id'] ?? 0);
$where='1=1'; $params=[];
if($search!==''){ $where.=" AND (t.name LIKE ? OR t.email LIKE ? OR t.phone LIKE ?)"; $params=["%$search%","%$search%","%$search%"]; }
if($prop_id){ $where.=" AND t.property_id=?"; $params[]=$prop_id; }
if(is_caretaker()){ $uid=current_user()['id']; $where.=" AND t.property_id IN (SELECT property_id FROM caretaker_properties WHERE user_id=?)"; $params[]=$uid; }
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create'])){
    $pdo->prepare("INSERT INTO tenants (name,email,phone,property_id,unit,monthly_rent) VALUES (?,?,?,?,?,?)")->execute([$_POST['name'],$_POST['email'],$_POST['phone'],(int)$_POST['property_id'],$_POST['unit'],(float)$_POST['monthly_rent']]);
  } elseif(isset($_POST['delete']) && is_admin()){
    $pdo->prepare("DELETE FROM tenants WHERE id=?")->execute([(int)$_POST['id']]);
  } elseif(isset($_POST['update'])){
    $pdo->prepare("UPDATE tenants SET name=?, email=?, phone=?, property_id=?, unit=?, monthly_rent=? WHERE id=?")->execute([$_POST['name'],$_POST['email'],$_POST['phone'],(int)$_POST['property_id'],$_POST['unit'],(float)$_POST['monthly_rent'],(int)$_POST['id']]);
  }
}
$rows_st=$pdo->prepare("SELECT t.*, p.name AS property_name FROM tenants t LEFT JOIN properties p ON p.id=t.property_id WHERE $where ORDER BY t.id DESC");
$rows_st->execute($params); $rows=$rows_st->fetchAll();
?>
<h2>Tenants</h2>
<form class="searchrow" method="get">
  <input name="q" value="<?= e($search) ?>" placeholder="Search tenants/email/phone">
  <select name="property_id"><option value="0">All properties</option><?php foreach($props as $p): ?><option value="<?= e($p['id']) ?>" <?= $prop_id==$p['id']?'selected':'' ?>><?= e($p['name']) ?></option><?php endforeach; ?></select>
  <button class="btn"><?= filter_icon() ?> Filter</button>
  <a class="btn" href="export_tenants.php">Export CSV</a>
  <?php if(is_admin()): ?><a class="btn" href="import_tenants.php">Import CSV</a><?php endif; ?>
</form>
<form method="post" class="grid">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="card"><label>Name</label><input name="name" required></div>
  <div class="card"><label>Email</label><input name="email" type="email"></div>
  <div class="card"><label>Phone</label><input name="phone"></div>
  <div class="card"><label>Property</label><select name="property_id"><?php foreach($props as $p): ?><option value="<?= e($p['id']) ?>"><?= e($p['name']) ?></option><?php endforeach; ?></select></div>
  <div class="card"><label>Unit</label><input name="unit"></div>
  <div class="card"><label>Monthly Rent (KES)</label><input name="monthly_rent" type="number" step="0.01" value="0"></div>
  <div class="card"><label>&nbsp;</label><button class="btn primary" name="create">Add Tenant</button></div>
</form>
<table>
  <tr><th>ID</th><th>Name</th><th>Contact</th><th>Property</th><th>Unit</th><th>Rent</th><th>Actions</th></tr>
  <?php foreach($rows as $r): ?>
  <tr>
    <td><?= e($r['id']) ?></td>
    <td><?= e($r['name']) ?></td>
    <td><?= e($r['email']) ?><br><span class="muted"><?= e($r['phone']) ?></span></td>
    <td><?= e($r['property_name']) ?></td>
    <td><?= e($r['unit']) ?></td>
    <td><?= number_format($r['monthly_rent'],2) ?></td>
    <td>
      <form method="post" style="display:inline-block">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <input type="hidden" name="name" value="<?= e($r['name']) ?>">
        <input type="hidden" name="email" value="<?= e($r['email']) ?>">
        <input type="hidden" name="phone" value="<?= e($r['phone']) ?>">
        <input type="hidden" name="property_id" value="<?= e($r['property_id']) ?>">
        <input type="hidden" name="unit" value="<?= e($r['unit']) ?>">
        <input type="hidden" name="monthly_rent" value="<?= e($r['monthly_rent']) ?>">
        <button class="btn" onclick="return editTenant(this)">Edit</button>
      </form>
      <?php if(is_admin()): ?>
      <form method="post" style="display:inline-block" onsubmit="return confirm('Delete tenant?')">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <button class="btn" name="delete">Delete</button>
      </form>
      <?php endif; ?>
      <a class="btn" href="statement.php?tenant_id=<?= e($r['id']) ?>">Statement</a>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
<script>
function editTenant(btn){
  const f=btn.closest('form'); const get=n=>f.querySelector('[name='+n+']').value;
  const id=get('id'), name=get('name'), email=get('email'), phone=get('phone'), property_id=get('property_id'), unit=get('unit'), monthly_rent=get('monthly_rent');
  btn.closest('tr').outerHTML = `<tr>
   <td>${id}</td>
   <td><form method="post"><input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>"><input type="hidden" name="id" value="${id}"><input name="name" value="${name}"></td>
   <td><input name="email" value="${email}"><br><input name="phone" value="${phone}"></td>
   <td><select name="property_id"><?php foreach($props as $p): ?><option value="<?= e($p['id']) ?>" ${property_id==="<?= e($p['id']) ?>"?'selected':''><?= e($p['name']) ?></option><?php endforeach; ?></select></td>
   <td><input name="unit" value="${unit}"></td>
   <td><input name="monthly_rent" type="number" step="0.01" value="${monthly_rent}"></td>
   <td><button class="btn primary" name="update">Save</button></form></td>
  </tr>`; return false;
}
</script>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
