<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
ensure_csrf();

$search = trim($_GET['q'] ?? '');
$where = '1=1'; $params=[];
if($search!==''){ $where .= " AND (name LIKE ? OR location LIKE ?)"; $params=["%$search%","%$search%"]; }
if(is_caretaker()){
  $uid = current_user()['id'];
  $where .= " AND id IN (SELECT property_id FROM caretaker_properties WHERE user_id=?)";
  $params[] = $uid;
}
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create']) && is_admin()){
    $pdo->prepare("INSERT INTO properties (name,location,units) VALUES (?,?,?)")->execute([$_POST['name'],$_POST['location'],(int)$_POST['units']]);
  } elseif(isset($_POST['delete']) && is_admin()){
    $pdo->prepare("DELETE FROM properties WHERE id=?")->execute([(int)$_POST['id']]);
  } elseif(isset($_POST['update']) && is_admin()){
    $pdo->prepare("UPDATE properties SET name=?, location=?, units=? WHERE id=?")->execute([$_POST['name'],$_POST['location'],(int)$_POST['units'],(int)$_POST['id']]);
  } elseif(isset($_POST['assign']) && is_admin()){
    $pdo->prepare("INSERT IGNORE INTO caretaker_properties (user_id, property_id) VALUES (?,?)")->execute([(int)$_POST['user_id'], (int)$_POST['property_id']]);
  } elseif(isset($_POST['unassign']) && is_admin()){
    $pdo->prepare("DELETE FROM caretaker_properties WHERE user_id=? AND property_id=?")->execute([(int)$_POST['user_id'], (int)$_POST['property_id']]);
  }
}
$rows_st = $pdo->prepare("SELECT * FROM properties WHERE $where ORDER BY id DESC");
$rows_st->execute($params);
$rows = $rows_st->fetchAll();
$caretakers = $pdo->query("SELECT id,name FROM users WHERE role='caretaker' ORDER BY name")->fetchAll();
?>
<h2>Properties</h2>
<form class="searchrow" method="get">
  <input name="q" value="<?= e($search) ?>" placeholder="Search properties">
  <button class="btn"><?= filter_icon() ?> Filter</button>
</form>
<?php if(is_admin()): ?>
<form method="post" class="grid">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="card"><label>Name</label><input name="name" required></div>
  <div class="card"><label>Location</label><input name="location"></div>
  <div class="card"><label>Total Units</label><input name="units" type="number" value="0"></div>
  <div class="card"><label>&nbsp;</label><button class="btn primary" name="create">Add Property</button></div>
</form>
<?php endif; ?>
<table>
  <tr><th>ID</th><th>Name</th><th>Location</th><th>Units</th><th>Assign Caretaker</th><th>Actions</th></tr>
  <?php foreach($rows as $r): ?>
  <tr>
    <td><?= e($r['id']) ?></td>
    <td><?= e($r['name']) ?></td>
    <td><?= e($r['location']) ?></td>
    <td><?= e($r['units']) ?></td>
    <td>
      <?php if(is_admin()): ?>
      <form method="post" style="display:flex;gap:6px;align-items:center">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="property_id" value="<?= e($r['id']) ?>">
        <select name="user_id">
          <?php foreach($caretakers as $c): ?><option value="<?= e($c['id']) ?>"><?= e($c['name']) ?></option><?php endforeach; ?>
        </select>
        <button class="btn" name="assign">Assign</button>
      </form>
      <?php endif; ?>
    </td>
    <td>
      <?php if(is_admin()): ?>
      <form method="post" style="display:inline-block">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <input type="hidden" name="name" value="<?= e($r['name']) ?>">
        <input type="hidden" name="location" value="<?= e($r['location']) ?>">
        <input type="hidden" name="units" value="<?= e($r['units']) ?>">
        <button class="btn" onclick="return editRow(this)">Edit</button>
      </form>
      <form method="post" style="display:inline-block" onsubmit="return confirm('Delete property?')">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <button class="btn" name="delete">Delete</button>
      </form>
      <?php endif; ?>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
<script>
function editRow(btn){
  const f=btn.closest('form'); const id=f.querySelector('[name=id]').value;
  const name=f.querySelector('[name=name]').value; const location=f.querySelector('[name=location]').value; const units=f.querySelector('[name=units]').value;
  const row=btn.closest('tr');
  row.outerHTML=`<tr>
    <td>${id}</td>
    <td><form method="post"><input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>"><input type="hidden" name="id" value="${id}"><input name="name" value="${name}"></td>
    <td><input name="location" value="${location}"></td>
    <td><input name="units" type="number" value="${units}"></td>
    <td></td>
    <td><button class="btn primary" name="update">Save</button></form></td>
  </tr>`; return false;
}
</script>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
